#ifndef CLOCK_H
#define CLOCK_H

#include "common.h"

#define EPOCH_YEAR 		1970

typedef struct
{
  unsigned int secs;			// Seconds.	[0-60] 
  unsigned int mins;			// Minutes.	[0-59] 
  unsigned int hours;		    // Hours.	[0-23] 
  unsigned int day;			    // Day.		[1-31] 
  unsigned int month;		    // Month.	[0-11] 
  unsigned int year;			// Year	since EPOCH
  unsigned int wday;            // weekday (0=Monday, 6=Sunday)
  unsigned int week;			// the first, second, third or fourth such weekday of the month
  unsigned int first;			// the first of the month is this weekday (0=Monday, 6=Sunday)
  unsigned int daylightSaving;	// 1 if daylightsaving time 0 otherwise
} TIME_T;

int isLeapYear(int);
DWORD yearSeconds(int);
DWORD monthSeconds(int, int);
void convertEpoch2Time(unsigned long, TIME_T*);
void ascTime(BYTE*, TIME_T);
void ascTimeEpoch(BYTE*, long);
void getTimeString(BYTE*);
DWORD SNTPGetUTCSeconds(void);
BYTE* uitoa(WORD, BYTE*);
BYTE* printADec(unsigned int, BYTE*);
DWORD SNTPGetSeconds(void);

#endif
